<?php
/*
 * Plugin Name: Woocommerce Mailchimp Discount
 * Plugin URI: http://magnigenie.com
 * Description: The plugin allows you to offer discounts to the users if they subscribe to your mailing list.
 * Version: 3.8
 * Author: Magnigenie
 * Author URI: http://magnigenie.com
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wc_mailchimp_discount
 */

// No direct file access
! defined( 'ABSPATH' ) AND exit;

define( 'WCMD_FILE', __FILE__ );
define( 'WCMD_PATH', plugin_dir_path( __FILE__ ) );
define( 'WCMD_BASE', plugin_basename( __FILE__ ) );
define( 'WCMD_OPTIONS_FRAMEWORK_DIRECTORY', plugins_url( '/', __FILE__ ) );
define( 'WCMD_OPTIONS_FRAMEWORK_PATH', dirname( __FILE__ ) . '/inc/' );
define( 'PLUGIN_NAME', 'WooCommerce Mailchimp Discount' );
define( 'WCMD_VERSION', '3.7' );

/**
* Checks WooCommerce is installed and activated
*
* @since 1.0
* @param empty
* @return mixed
*
*/
function wcmd_check_required_plugins() {

	if ( ! class_exists( 'WooCommerce' ) ) {
		?>
		<div id="message" class="error">
      <p>WooCommerce Mailchimp Discount requires <a href="http://www.woothemes.com/woocommerce/" target="_blank">WooCommerce</a> to be activated in order to work. Please install and activate <a href="<?php echo admin_url('/plugin-install.php?tab=search&amp;type=term&amp;s=WooCommerce'); ?>" target="">WooCommerce</a> first.</p>
    </div>
    <?php
		
		deactivate_plugins( WCMD_BASE );
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
	}
}
add_action( 'admin_notices', 'wcmd_check_required_plugins' );

/**
* Load text domain for our plugin
*
* @since 1.0
* @param empty
* @return mixed
*
*/
function wcmd_load_textdomain() {
	load_plugin_textdomain( 'wc_mailchimp_discount', false, WCMD_PATH. '/languages/' );
}
add_action( 'plugins_loaded', 'wcmd_load_textdomain' );

/**
* Install data for options framework from old database structure
*
* @since 3.0
* @param empty
* @return mixed
*
*/
function wcmd_install() {

	$check_data_imported = get_option( 'wcmd_data_imported' );
	
  if( $check_data_imported == 'yes' ){
		return;
  }

	global $wpdb;
	$options_table = $wpdb->prefix .'options';
	$wcmd_array = array();

	$older_datas = $wpdb->get_results( "SELECT option_name,option_value FROM $options_table WHERE option_name LIKE 'wcmd_%' ");
	
	if( is_array( $older_datas ) && !empty( $older_datas ) ) {
		foreach( $older_datas as $older_data ) {
			if( isset( $older_data->option_name ) && isset( $older_data->option_value ) ) {
				$wcmd_array[$older_data->option_name] = $older_data->option_value;
			}
		}
	}

	update_option( 'wcmd_options', $wcmd_array );
	update_option( 'wcmd_data_imported', 'yes' );
}
register_activation_hook( __FILE__, 'wcmd_install' );

if( !class_exists( 'MGMailChimp' ) ) 
	require WCMD_PATH . '/inc/class-mailchimp.php';

require_once WCMD_PATH . '/inc/options-framework.php';
require_once WCMD_PATH . '/inc/class-woo-mailchimp-discount.php';
new WC_MailChimp_Discount();